import unittest

from weapon import Weapon

class WeaponTest(unittest.TestCase):
    
    def test_get_name(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        self.assertEqual("Test Weapon", test_weapon.get_name())
    
    def test_get_attacks(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        self.assertEqual(10, test_weapon.get_attacks())
    
    def test_get_durability(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        self.assertEqual(100, test_weapon.get_durability())
    
    def test_get_max_durability(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        self.assertEqual(100, test_weapon.get_max_durability())
    
    def test_is_usable(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        self.assertTrue(test_weapon.is_usable())
    
    def test_damage(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        test_weapon.damage(10)
        self.assertEqual(90, test_weapon.get_durability())

        test_weapon.damage(25)
        self.assertEqual(65, test_weapon.get_durability())
        self.assertTrue(test_weapon.is_usable())

        test_weapon.damage(80)
        self.assertEqual(0, test_weapon.get_durability())

        self.assertFalse(test_weapon.is_usable())

    def test_repair(self):
        test_weapon = Weapon("Test Weapon", 10, 100)
        test_weapon.damage(10)
        test_weapon.repair()
        self.assertEqual(100, test_weapon.get_durability())
        self.assertTrue(test_weapon.is_usable())

if __name__ == '__main__':
    unittest.main()