import csv
import os
import numpy as np
from sklearn.linear_model import LinearRegression


DATA_FILE = 'usedcars.csv'
PATH = os.path.dirname(os.path.abspath(__file__))

# Read the data file
with open(os.path.join(PATH, DATA_FILE), 'r') as f:
    reader = csv.reader(f)
    data = list(reader)

# Remove the header
data = data[1:]

# Compute the input features
inputs = [[
            float(mileage),
        ]
        for (year, model, price, mileage, color, transmission) in data
    ]

# Compute the targets
targets = [
        float(price)
        for (year, model, price, mileage, color, transmission) in data
    ]

# Define the model
model = LinearRegression()

# Train the model
model.fit(inputs, targets)

# Print the model parameters
print('Model parameters:')
for i, coef in enumerate(model.coef_):
    print(f' Parameter {i}: {coef}')
print(f' Bias: {model.intercept_}')

# Compute standard deviation
predictions = model.predict(inputs)
errors = np.array(predictions) - np.array(targets)
print('Mean squared error: %f' % np.mean(errors**2))
print('Standard deviation: %f' % np.std(errors))
