import random
from getpass import getpass

from state import get_pegs
from solver import *


def ask_colors():
    while True:
        colors = input("Entrez le nombre de couleurs : ")
        try:
            colors = int(colors)
            if colors < 1:
                raise ValueError()
            return colors
        except ValueError:
            print("Nombre de couleurs invalide. Entrez un nombre entier positif.")


def ask_size():
    while True:
        size = input("Entrez la taille de la combinaison : ")
        try:
            size = int(size)
            if size < 1:
                raise ValueError()
            return size
        except ValueError:
            print("Taille invalide. Entrez un nombre entier positif.")


def ask_code(size, colors, hidden):
    while True:
        if hidden:
            solution = getpass("Entrez une combinaison : ")
        else:
            solution = input("Entrez une combinaison : ")
        try:
            solution = solution.split()
            solution = [int(color) for color in solution]
            if len(solution) != size:
                raise ValueError()
            for color in solution:
                if color < 1 or color > colors:
                    raise ValueError()
            return solution
        except ValueError:
            print("Combinaison invalide. Entrez une liste de", size, "nombres entiers entre 1 et", colors)


def ask_pegs(candidate, solution):
    if candidate is not None and solution is not None:
        pegs = get_pegs(candidate, solution)
        print("Il y a", pegs[0], "pions rouges et", pegs[1], "pions blancs.")
        return pegs
    while True:
        pegs = input("Entrez le nombre de pions de rouge et de blancs : ")
        try:
            pegs = pegs.split()
            if len(pegs) != 2:
                raise ValueError()
            pegs = tuple(int(peg) for peg in pegs)
            if pegs[0] < 0 or pegs[1] < 0:
                raise ValueError()
            return pegs
        except ValueError:
            print("Nombre de pions invalide. Entrez deux nombres entiers positifs ou nuls.")


def random_solution(size, colors):
    return [random.randint(1, colors) for _ in range(size)]


def make_user_guess(size, colors, solution):
    count = 1
    while True:
        candidate = ask_code(size, colors, False)
        pegs = ask_pegs(candidate, solution)
        if pegs == (size, 0):
            print("Vous avez gagné en", count, "coups !")
            break
        count += 1


def make_computer_guess(size, colors, solution):
    solutions = all_solutions(size, colors)
    count = 1
    while True:
        candidate = best_move(solutions)
        print("Le code", ' '.join([str(i) for i in candidate]), "a été joué.")
        pegs = ask_pegs(candidate, solution)
        if pegs == (size, 0):
            print("L'ordinateur a gagné en", count, "coups !")
            break
        count += 1
        solutions = filter_solutions(solutions, candidate, pegs)
        print(len(solutions), "solutions restantes.")
        if len(solutions) == 0:
            print("Il n'y a pas de solution.")
            break


if __name__ == "__main__":
    colors = 6  # ask_colors()  # Pour demander le nombre de couleurs à l'utilisateur.
    size = 4  # ask_size()  # Pour demander la taille du code à l'utilisateur.

    print("=== Entrez la solution ===")
    solution = random_solution(size, colors)  # Pour générer une solution aléatoire.
    # solution = ask_code(size, colors, True)  # Pour demander la solution à l'utilisateur.
    # solution = None  # Pour ne pas donner la solution à l'ordinateur.

    print("=== Entrez les coups ===")
    make_user_guess(size, colors, solution)  # Pour laisser l'utilisateur jouer.
    # make_computer_guess(size, colors, solution)  # Pour laisser l'ordinateur jouer.



    


