import random

JACK = 11
QUEEN = 12
KING = 13
ACE = 14

CLUBS = 0
DIAMONDS = 1
HEARTS = 2
SPADES = 3

class Card(object):
    def __init__(self, rank, suit):
        self.rank = rank
        self.suit = suit

    def get_rank(self):
        return self.rank
    
    def get_suit(self):
        return self.suit
    
    def get_values(self):
        if self.rank == ACE:
            return [1, 11]
        elif self.rank >= JACK:
            return [10]
        else:
            return [self.rank]
    
    def __str__(self):
        rank_name = str(self.rank) if self.rank <= 10 else \
            {JACK: 'J', QUEEN: 'Q', KING: 'K', ACE: 'A'}[self.rank]
        suit_name = {CLUBS: 'C', DIAMONDS: 'D', HEARTS: 'H', SPADES: 'S'}[self.suit]
        return rank_name + "-" + suit_name


def read_card(string):
    rank_name, suit_name = string.split('-')
    rank = int(rank_name) if rank_name.isdigit() else \
        {'J': JACK, 'Q': QUEEN, 'K': KING, 'A': ACE}[rank_name]
    suit = {'C': CLUBS, 'D': DIAMONDS, 'H': HEARTS, 'S': SPADES}[suit_name]
    return Card(rank, suit)


class Hand(object):
    def __init__(self):
        self.hand = []
    
    def get_hand_size(self):
        return len(self.hand)
    
    def add_card(self, card):
        self.hand.append(card)

    def remove_last_card(self):
        return self.hand.pop()
    
    def get_non_bust_hand_values(self):
        pass
    
    def get_best_hand_value(self):
        pass
    
    def is_bust(self):
        pass
    
    def is_blackjack(self):
        pass
    
    def get_moves(self):
        if self.is_blackjack():
            return ['stand']
        if self.is_bust():
            return ['stand']
        
        moves = ['hit', 'stand']
        if len(self.hand) == 2:
            moves.append('double')
        return moves
    
    def __str__(self):
        return ' '.join(str(card) for card in self.hand)
        

    

    
