import sys

from simulator import *
from state import *

def enter_card():
    while True:
        try:
            card_text = input("Entrer une carte: ")
            if card_text == "":
                sys.exit()
            return read_card(card_text)
        except ValueError:
            print("Nom de carte invalide. Exemples : 5-H, 10-S, A-D, J-C, ...")

def show_results(player_hand, dealer_card):
        print("Main du joueur :", player_hand)
        print("Carte visible du croupier :", dealer_card)
        print("Coup à jouer :", best_move(player_hand, dealer_card))
        print("Est. gain :", "{:.2f}".format(estimate(player_hand, dealer_card)), "fois la mise")
        print()

if __name__ == "__main__":
    print("Bienvenue dans le simulateur de Blackjack !")

    player_hand = Hand()
    print("Votre main. Chaque carte est entrée sous la forme 5-H, 10-S, A-D, J-C, ...")
    player_hand.add_card(enter_card())
    player_hand.add_card(enter_card())
    print()
    print("Carte visible du croupier :")
    dealer_card = enter_card()
    print()
    show_results(player_hand, dealer_card)